/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai.attributes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.util.registry.Registry;

public class AttributeModifierMap {
    private final Map<Attribute, ModifiableAttributeInstance> field_233802_a_;

    public AttributeModifierMap(Map<Attribute, ModifiableAttributeInstance> map) {
        this.field_233802_a_ = ImmutableMap.copyOf(map);
    }

    private ModifiableAttributeInstance func_233810_d_(Attribute attribute) {
        ModifiableAttributeInstance modifiableAttributeInstance = this.field_233802_a_.get(attribute);
        if (modifiableAttributeInstance == null) {
            throw new IllegalArgumentException("Can't find attribute " + Registry.field_239692_aP_.func_177774_c(attribute));
        }
        return modifiableAttributeInstance;
    }

    public double func_233804_a_(Attribute attribute) {
        return this.func_233810_d_(attribute).func_111126_e();
    }

    public double func_233807_b_(Attribute attribute) {
        return this.func_233810_d_(attribute).func_111125_b();
    }

    public double func_233805_a_(Attribute attribute, UUID uUID) {
        AttributeModifier attributeModifier = this.func_233810_d_(attribute).func_111127_a(uUID);
        if (attributeModifier == null) {
            throw new IllegalArgumentException("Can't find modifier " + uUID + " on attribute " + Registry.field_239692_aP_.func_177774_c(attribute));
        }
        return attributeModifier.func_111164_d();
    }

    @Nullable
    public ModifiableAttributeInstance func_233806_a_(Consumer<ModifiableAttributeInstance> consumer, Attribute attribute) {
        ModifiableAttributeInstance modifiableAttributeInstance = this.field_233802_a_.get(attribute);
        if (modifiableAttributeInstance == null) {
            return null;
        }
        \u2603 = new ModifiableAttributeInstance(attribute, consumer);
        \u2603.func_233763_a_(modifiableAttributeInstance);
        return \u2603;
    }

    public static MutableAttribute func_233803_a_() {
        return new MutableAttribute();
    }

    public boolean func_233809_c_(Attribute attribute) {
        return this.field_233802_a_.containsKey(attribute);
    }

    public boolean func_233808_b_(Attribute attribute, UUID uUID) {
        ModifiableAttributeInstance modifiableAttributeInstance = this.field_233802_a_.get(attribute);
        return modifiableAttributeInstance != null && modifiableAttributeInstance.func_111127_a(uUID) != null;
    }

    public static class MutableAttribute {
        private final Map<Attribute, ModifiableAttributeInstance> field_233811_a_ = Maps.newHashMap();
        private boolean field_233812_b_;

        private ModifiableAttributeInstance func_233817_b_(Attribute attribute) {
            ModifiableAttributeInstance modifiableAttributeInstance2 = new ModifiableAttributeInstance(attribute, modifiableAttributeInstance -> {
                if (this.field_233812_b_) {
                    throw new UnsupportedOperationException("Tried to change value for default attribute instance: " + Registry.field_239692_aP_.func_177774_c(attribute));
                }
            });
            this.field_233811_a_.put(attribute, modifiableAttributeInstance2);
            return modifiableAttributeInstance2;
        }

        public MutableAttribute func_233814_a_(Attribute attribute) {
            this.func_233817_b_(attribute);
            return this;
        }

        public MutableAttribute func_233815_a_(Attribute attribute, double d) {
            ModifiableAttributeInstance modifiableAttributeInstance = this.func_233817_b_(attribute);
            modifiableAttributeInstance.func_111128_a(d);
            return this;
        }

        public AttributeModifierMap func_233813_a_() {
            this.field_233812_b_ = true;
            return new AttributeModifierMap(this.field_233811_a_);
        }
    }
}

